﻿using GenerateBarcodes;
using System;
using System.Collections.Generic;
using System.Reflection;

namespace BarcodeCSharpSample
{
    class Program
    {
        static void Main(string[] args)
        {
            List<string> bar13 = new List<string> { "490175041295", "453171407022", "496988726825", "451460330781" };
            List<string> bar8 = new List<string> { "4901234", "4996871", "4900000", "4946122" };
            List<string> bar39 = new List<string> { "012345ABCDEFG", "MNOPQRSTU", "XYZ/+% -.", "1 2 3 4 5 6" };
            List<string> bar128 = new List<string> { "{STARTA}987{ACK}{NAK}{SHIFT}XYZ[^_]",
                                                            "{startb}appleAPPLE{COdeA}{SHIFT}(#$%&)CDA",
                                                            "{STARTB}{:;<=>?@}{SP}StartB",
                                                            "{STARTB}Windows(001)-987{CODEA}*AB",
                                                            "{StartA}!\"#$%&'(*+,-.){sp}{Codeb}12ab",
                                                            "{starta}SAGAMI-SYSTEM123(.,/!)",
                                                            "{startc}9865432109{codeb}codeB{SP} {1}",
                                                            "{startb}~<StartB>{CodeA}{Codeb}barcode"};

            //バーコードパラメータ生成
            // バーコード文字列
            // 出力フォルダパス
            // バーコード種別
            // 文字列表示フラグ(Code128/Code39)
            // チェックディジット付加フラグ(Code39)
            // スタートストップビット表示フラグ(Code39)
            // トランケーション：バーの高さ(JAN)
            // キャラクタ間ギャップ(Code39)
            // 出力ファイル名
            // 出力ファイル種別(BMP/PNG/JGP/JPEG)
            BarcodeParam myParam = new BarcodeParam(
                "00000000",
                System.IO.Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location),
                BarcodeKind.Jan13,
                true,
                true,
                true,
                11,
                1.0,
                "sample",
                "bmp"
            );
            GenerateBarcode generateBar = new GenerateBarcode(myParam);

            //出力ファイルカウンター定義
            int cnt = 1;
            //JAN13 バーコード生成
            foreach(string s in bar13)
            {
                myParam.SelectedBarcodeKind = BarcodeKind.Jan13;
                myParam.BarcodeFileName = cnt.ToString("00") + "-sample(jan13)";
                myParam.BarcodeText = s;
                //パラメータ設定
                generateBar.SetBarcodeParam(myParam);
                //バーコード出力
                BarcodeErrTypes errType = generateBar.GenerateBarcodeMain();
                if (errType != BarcodeErrTypes.BarcodeSuccess)
                {
                    System.Diagnostics.Trace.WriteLine(GetMessage(errType));
                    Console.WriteLine(GetMessage(errType) + "\r\nPress Any Key!!");
                    Console.ReadKey();
                    return;
                }
                cnt++;
            }

            //Jan8バーコード生成
            foreach(string s in bar8)
            {
                myParam.SelectedBarcodeKind = BarcodeKind.Jan8;
                myParam.BarcodeFileName = cnt.ToString("00") + "-sample(jan8)";
                myParam.BarcodeText = s;
                //パラメータ設定
                generateBar.SetBarcodeParam(myParam);
                //バーコード出力
                BarcodeErrTypes errType = generateBar.GenerateBarcodeMain();
                if (errType != BarcodeErrTypes.BarcodeSuccess)
                {
                    System.Diagnostics.Trace.WriteLine(GetMessage(errType));
                    Console.WriteLine(GetMessage(errType) + "\r\nPress Any Key!!");
                    Console.ReadKey();
                    return;
                }
                cnt++;
            }

            //Code39バーコード生成
            foreach (string s in bar39)
            {
                myParam.SelectedBarcodeKind = BarcodeKind.Code39;
                myParam.BarcodeFileName = cnt.ToString("00") + "-sample(code39)";
                myParam.BarcodeText = s;
                //パラメータ設定
                generateBar.SetBarcodeParam(myParam);
                //バーコード出力
                BarcodeErrTypes errType = generateBar.GenerateBarcodeMain();
                if (errType != BarcodeErrTypes.BarcodeSuccess)
                {
                    System.Diagnostics.Trace.WriteLine(GetMessage(errType));
                    Console.WriteLine(GetMessage(errType) + "\r\nPress Any Key!!");
                    Console.ReadKey();
                    return;
                }
                cnt++;
            }

            //Code128バーコード生成
            foreach (string s in bar128)
            {
                myParam.SelectedBarcodeKind = BarcodeKind.Code128;
                myParam.BarcodeFileName = cnt.ToString("00") + "-sample(code128)";
                myParam.BarcodeText = s;
                //パラメータ設定
                generateBar.SetBarcodeParam(myParam);
                //バーコード出力
                BarcodeErrTypes errType = generateBar.GenerateBarcodeMain();
                if (errType != BarcodeErrTypes.BarcodeSuccess)
                {
                    System.Diagnostics.Trace.WriteLine(GetMessage(errType));
                    Console.WriteLine(GetMessage(errType) + "\r\nPress Any Key!!");
                    Console.ReadKey();
                    return;
                }
                cnt++;
            }
        }

        /// <summary>
        /// メッセージを取得
        /// </summary>
        /// <param name="errType">BarcodeErrTypes</param>
        /// <returns></returns>
        static string GetMessage(BarcodeErrTypes errType)
        {
            switch (errType)
            {
                case BarcodeErrTypes.BarcodeParameterIsNull:
                    return "Barcode parameter is Null.\r\nバーコードパラメータが未設定です";
                case BarcodeErrTypes.InvalidBarcodeType:
                    return "Barcode type not recognized.\r\n認識できないバーコードタイプです";
                case BarcodeErrTypes.FailureCheckdigitCreation:
                    return "Check digit could not be calculated.\r\nチェックディジットの計算ができませんでした";
                case BarcodeErrTypes.FailureCreateBarcode:
                    return "Barcode image creation failed.\r\nバーコードイメージ作成に失敗しました";
                case BarcodeErrTypes.NoCharactersSpecified:
                    return "Barcode target character is not set.\r\nバーコード文字列が未設定です";
                case BarcodeErrTypes.InvalidNumberOfDigits:
                    return "Enter the JAN Code with 12 or 7 digits.\r\nJANコードは12桁または7桁が有効です";
                case BarcodeErrTypes.NonNumericValueSet:
                    return "JAN code is only for numeric values.\r\nJANコードで設定できるのは数値のみです";
                case BarcodeErrTypes.NonTargetCharacterSpecified:
                    return "A non-target character was specified in Code39.\r\nコード39の対象外の文字です";
                case BarcodeErrTypes.CharacterLimitIs50:
                    return "Enter Code39 within 50 digits.\r\nコード39は50文字以下で設定してください";
                case BarcodeErrTypes.StartCodeNotBeDetected:
                    return "Code128 must start with a start code.\r\nコード128でスタートコードが指定されていません";
                case BarcodeErrTypes.OneDataCharacterFailure:
                    return "Code128 character could not be obtained.\r\nコード128で指定文字が見つかりませんでした";
                case BarcodeErrTypes.NextOneCharacterFailure:
                    return "Code128 character pattern could not be obtained.\r\nコード128で指定文字パターンが見つかりませんでした";
                case BarcodeErrTypes.FailureBarcodeImageOutput:
                    return "Barcode image file output failed.\r\nバーコードイメージの出力に失敗しました";
                case BarcodeErrTypes.UnKnownErrorOccurred:
                    return "An unexpected error has occurred.\r\n予期しないエラーが発生しました";
                case BarcodeErrTypes.BarcodeSuccess:
                    return "Successfully created barcode.\r\nバーコードイメージ作成が終了しました";
                default:
                    break;
            }

            return string.Empty;
        }
    }
}
